#ifdef AVEVAD
#define _GLIBCXX_DEBUG
#else
//#pragma GCC optimize("Ofast")
//#pragma GCC target("avx,avx2,sse,abm,mmx,popcnt")
#endif

#include <bits/stdc++.h>
#include <bits/extc++.h>

#define LC(V) (2*(V)+1)
#define RC(V) (2*(V)+2)

using namespace std;
using namespace __gnu_pbds;
using ll = long long;
template<typename T>
using ordered_set = tree<T, null_type, less<T>, rb_tree_tag, tree_order_statistics_node_update>;

ll sgn(ll x) {
    if (x < 0) return -1;
    if (x > 0) return +1;
    return 0;
}

struct P {
    ll x, y;

    P(ll x, ll y) : x(x), y(y) {}

    P() : P(0, 0) {}

    P operator-(const P &p) const {
        return {x - p.x, y - p.y};
    }

    ll operator*(const P &p) const {
        return x * p.x + y * p.y;
    }

    ll operator%(const P &p) const {
        return x * p.y - y * p.x;
    }
};

bool has_intersection(const P &a1, const P &b1, const P &a2, const P &b2) {
    ll f1 = sgn((b1 - a1) % (b2 - a1)) * sgn((b1 - a1) % (a2 - a1));
    ll f2 = sgn((b2 - a2) % (a1 - a2)) * sgn((b2 - a2) % (b1 - a2));
    return f1 != 1 && f2 != 1;
}

int main() {
#ifndef AVEVAD
    cin.tie(0);
    ios_base::sync_with_stdio(0);
#endif
    ll t;
    cin >> t;
    while (t--) {
        ll n;
        cin >> n;
        vector<pair<P, P>> f(n);
        for (auto &[a, b] : f) cin >> a.x >> a.y >> b.x >> b.y;
        ll m = 0;
        for (ll i = 0; i < n; i++) {
            auto [a1, b1] = f[i];
            for (ll j = 0; j < i; j++) {
                auto [a2, b2] = f[j];
                if (has_intersection(a1, b1, a2, b2)) m++;
            }
        }
        ll ans = m - n + 2;
        cout << ans << '\n';
    }
}